<?php

namespace App\Http\Controllers\backend;

use Carbon\Carbon;
use App\Models\Service;
use App\Models\Category;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use App\Http\Controllers\Controller;
use App\Http\Requests\ServiceRequest;
use App\Http\Requests\ServiceUpdateRequest;

class ServiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->ajax()) {
            return $this->dataTable();
        }

        return view('backend.service.index');
    }
    private function dataTable()
    {
        $query = Service::query();
            return DataTables::of($query)
                       ->addColumn('action' , function($service)
                       {
                        return view('backend.action.service' , ['service' => $service]);

                       })
                       ->addColumn('category_id' , function($service)
                       {
                        return view('backend.action.service_category' , ['service' => $service]);
                       })
                       ->order(function ($service)
                       {
                        $service->orderBy('created_at' , 'desc');
                       })
                       ->addColumn('created_at' , function ($data)
                      {
                        return date('d-M-Y H:i:s' , strtotime($data->created_at));
                      })
                      ->addColumn('updated_at' , function ($data)
                      {
                        return Carbon::parse($data->updated_at)->format('d-M-Y H:i:s');
                      })
                      ->rawColumns(['action'])
                      ->make(true);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = Category::query()->get();
        return view('backend.service.create' , ['categories' => $categories]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ServiceRequest $request)
    {
        $attributes = $request->validated();
        $images = [];
        if($request->hasFile('image')){
        foreach ($attributes['image'] as $image) {
            $file_name = uploadFile($image, 'images');
            array_push($images,$file_name);
         }
         $attributes['image'] = implode(',',$images);
        }
        $category = $attributes['category_id'];
        unset($attributes['category_id']);
        $service = Service::create($attributes);
        $service->Category()->attach($category); 
        return redirect()->route('service.index')->with('success' , 'Service is successfully created!');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Service $service)
    {
        $service_images = explode(',', $service->image);
        return view('backend.service.show' , ['service_images' => $service_images,'service' => $service]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Service $service)
    {
        $category_service = $service->Category->pluck('id', 'id')->toArray();
        $categories = Category::pluck('title', 'id')->toArray();
        return view('backend.service.edit',[
            'service' => $service,
            'categories' => $categories,
            'category_service' => $category_service
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(ServiceUpdateRequest $request, Service $service)
    {
        $attributes = $request->validated();
        $images = [];
        if($request->hasFile('image')){
        foreach ($attributes['image'] as $image) {
            $file_name = uploadFile($image, 'images');
            array_push($images,$file_name);
         }
         $attributes['image'] = implode(',',$images);
        }
        $category =$attributes['category_id'];
        unset($attributes['category_id']);
        $service->update($attributes);
        $service->Category()->sync($category);
        return redirect()->route('service.index')->with('success' , 'Service is successfully updated!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Service $service)
    {
        $service->delete();
        return 'success';
    }
}
