<?php

namespace App\Http\Controllers\frontend;

use App\Models\Service;
use App\Models\Category;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ServicesController extends Controller
{
    public function index()
    {
        $service_query = Service::query()->latest()->filter(request()->all());
        $services = $service_query->paginate(6);
        $categories = Category::pluck('title', 'id')->toArray();
        return view('frontend.service',['services' => $services , 'categories' => $categories ]);
    }

    // public function serviceHome()
    // {
    //     // $service_query = Service::latest()->get();
    //     $services = Service::latest()->paginate(6);
    //     $categories = Category::pluck('title', 'id')->toArray();
    //     return view('frontend.service',['services' => $services , 'categories' => $categories ]);
    // }

    public function serviceAll()
    {
        $services = Service::query()->get();
        return response()->json([
                'status' => 'success',
                'data' => $services
        ]);
        
    }
 
    public function detail($service)
    {
        $service_detail = Service::where('slug' , $service)->get()->toArray();
        $service_images = explode(',', $service_detail[0]['image']);
        return view('frontend.service_detail',['service_detail' => $service_detail,'service_images' => $service_images ]);
    }
}
