@extends('frontend.layouts.app')
@section('projects','nav-link')
@section('content')
            <div class="page-nav no-margin row">
                <div class="container">
                    <div class="row">
                        <h2 class="text-start">Our Project Achievements</h2>
                        <ul class="detail">
                            <li> <a href="{{ route('home') }}"><i class="bi bi-house-door"></i> Home</a></li>
                            <li><i class="bi bi-chevron-double-right pe-2"></i> <span style="color:#EDB027;">Project Achievement</span></li>
                        </ul>
                    </div>
                </div>
            </div>
            <div id="testimonial" class="service bg-honey big-padding bg-gray container-fluid px-4 py-5">
                <div class="container-xl infinite-scroll">
                    <div class="row">
                        @foreach($projects as $project)
                                <div class="card mb-2" style="height:60px;border-radius: 10px;box-shadow: 0 3px 4px rgba(0,0,0,0.09);border: none;">
                                        <div class="card-body p-2">
                                          <h5 style="color:#EDB027;">{{ $project->address }}</h5>
                                        </div>
                                </div> 
                        @foreach($project_images = explode(',', $project->image) as $project_image)
                                <div class="col-xl-3 col-md-6 mb-4">
                                    <div class="bg-white shadow-md">
                                    @if(!$project_image == '')
                                    <img src="{{asset('images/' . $project_image)}}" alt="" style="width:800px;height:300px;padding:2px;object-fit:contain;" class="border border-dark border-2 rounded w-full ">
                                    @else
                                    <img src="{{asset('backend/assets/img/noimage.jpg')}}" alt="" style="width:500px;height:200px;padding:2px;object-fit:contain;" class="border border-dark border-2 rounded w-full ">
                                    @endif
                                    </div>
                                </div>
                        @endforeach             
                        @endforeach
                        {{$projects->links()}}
                    </div>
                </div>   
            </div>
@endsection
@push('script')
    <script src="{{ asset('frontend/assets/js/jscroll.min.js') }}"></script>
    <script>
        $('ul.pagination').hide();
          $(function() {
              $('.infinite-scroll').jscroll({
                  autoTrigger: true,
                  loadingHtml: `<img class="mx-auto d-block " src="{{ asset('frontend/assets/images/loading.gif') }}" alt="Loading..." />`,
                  padding: 0,
                  nextSelector: '.pagination li.active + li a',
                  contentSelector: 'div.infinite-scroll',
                  callback: function() {
                      $('ul.pagination').remove();
                  }
              });
            });
    </script>
@endpush   

       
        